<?php

function getCurrencyPrice(string $currency): ?float
{
    $url = "https://widget-data.bitycle.com/c1/api/exchange/source_prices?source=101";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_CONNECTTIMEOUT => 5
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($response === false || $error) {
        return null;
    }

    $data = json_decode($response, true);

    if (is_array($data) && isset($data['data'][$currency . "IRT"]) && is_numeric($data['data'][$currency . "IRT"])) {
        return floatval($data['data'][$currency . "IRT"]);
    }

    return null;
}
$price = getCurrencyPrice('BTC');
if ($price !== null) {
    echo "BTC price: $price تومان";
} else {
    echo "خطا در دریافت قیمت بیت‌کوین!";
}
