<?php
date_default_timezone_set("Asia/Tehran");
$token = '7528757132:AAHqg3J64XzppYYYknHPkBNYIavtchER0qU';

/**
 * @param $method
 * @param array $datas
 * @return mixed
 */
function bot($method, array $datas = []): mixed
{
    global $token;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.telegram.org/bot' . $token . '/' . $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    return json_decode(curl_exec($ch), true);
}

/**
 * @param $chatid
 * @param $text
 * @param $keyboard
 * @param $reply
 * @return mixed
 */
function send($text, $chatid = null, $keyboard = null, $reply = null, $sp_mode = true, $notif = true)
{
    global $chid,$mid;
    $peer = $chatid ?? $chid;
    if ($sp_mode) {
        return bot('sendMessage', ['chat_id' => $peer, 'text' => $text, 'disable_web_page_preview' => true, 'reply_to_message_id' => $reply, 'reply_markup' => $keyboard, 'reply_to_message_id' => $mid, 'parse_mode' => 'MarkDown', 'disable_notification' => $notif]);
    } else {
        return bot('sendMessage', ['chat_id' => $peer, 'text' => $text, 'disable_web_page_preview' => true, 'reply_to_message_id' => $reply, 'reply_markup' => $keyboard, 'parse_mode' => 'MarkDown', 'disable_notification' => $notif]);
    }
}

/**
 * @param $call_id
 * @param $text
 * @param $show_alert
 * @return mixed
 */
function answer($call_id, $text = null, $show_alert = null): mixed
{
    return bot('answerCallbackQuery', ['callback_query_id' => $call_id, 'text' => $text, 'show_alert' => $show_alert]);
}

/**
 * @param $chatid
 * @param $msgid
 * @param $text
 * @param $keyboard
 * @return mixed
 */
function edit($chatid, $msgid, $text, $keyboard = null): mixed
{
    return bot('editMessageText', ['chat_id' => $chatid, 'message_id' => $msgid, 'text' => $text, 'disable_web_page_preview' => true, 'reply_markup' => $keyboard]);
}

/**
 * @param $chat_id
 * @return array
 */
function getGroupAdmins($chat_id): array
{
    $response = bot('getChatAdministrators', ['chat_id' => $chat_id]);
    $admins = [];
    if ($response['ok']) {
        foreach ($response['result'] as $admin) {
            $user = $admin['user'];
            if ($user['is_bot']) {
                continue;
            }
            $name = $user['first_name'] ?? 'کاربر';
            if (isset($user['last_name'])) {
                $name .= ' ' . $user['last_name'];
            }
            $admins[] = [
                'id' => $user['id'],
                'name' => $name,
            ];
        }
    }
    return $admins;
}

/**
 * @param $chat_id
 * @param $message_id
 * @return void
 */
function deleteMessage($chat_id, $message_id): void
{
    bot('deleteMessage', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
    ]);
}

/**
 * @param $transactionHash
 * @return array
 */
function getTransactionFromTronScan($transactionHash): array
{
    $url = "https://apilist.tronscanapi.com/api/transaction-info?hash=$transactionHash";
    $json = @file_get_contents($url);

    if (!$json) {
        return [];
    }

    $data = json_decode($json, true);
    return is_array($data) ? $data : [];
}


function translateCurrency(string $currency): string
{
    $translations = [
        'بیتکوین' => 'BTC',
        'بیت کوین' => 'BTC',
        'بیتکوین کش' => 'BCH',
        'بیت کوین کش' => 'BCH',
        'اتریوم' => 'ETH',
        'اتریوم کلاسیک' => 'ETC',
        'ترون' => 'TRX',
        'تون' => 'TON',
        'تورن' => 'TRX',
        'دوج' => 'DOGE',
        'دوج کوین' => 'DOGE',
        'تتر' => 'USDT',
        'یو اس دی تی' => 'USDT',
        'تتر ترون' => 'USDT',
        'تتر شبکه ترون' => 'USDT',
        'کاردانو' => 'ADA',
        'ادا' => 'ADA',
        'ریپل' => 'XRP',
        'لایت کوین' => 'LTC',
        'لایتکوین' => 'LTC',
        'پولکادات' => 'DOT',
        'دات' => 'DOT',
        'سولانا' => 'SOL',
        'آواکس' => 'AVAX',
        'اواکس' => 'AVAX',
        'بایننس کوین' => 'BNB',
        'بایننس' => 'BNB',
        'بی ان بی' => 'BNB',
        'شیبا' => 'SHIB',
        'شیبا اینو' => 'SHIB',
        'ایاس' => 'EOS',
        'فایل کوین' => 'FIL',
        'فایلکوین' => 'FIL',
        'مونرو' => 'XMR',
        'زی کش' => 'ZEC',
        'زی‌کش' => 'ZEC',
        'پالیگان' => 'MATIC',
        'ماتیک' => 'MATIC',
        'یو اس دی کوین' => 'USDC',
        'دلار دیجیتال' => 'USDC',
        'چین لینکac' => 'LINK',
        'لینک' => 'LINK'
    ];
    $currency = $translations[$currency] ?? $currency;
    //$currency = strtolower($currency);
    return $currency;
}

function getCurrencyPrice($currency)
{
    $url = "https://widget-data.bitycle.com/c1/api/exchange/source_prices?source=101";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_CONNECTTIMEOUT => 5
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($response === false || $error) {
        return null;
    }

    $data = json_decode($response, true);

    if (is_array($data) && isset($data['data'][$currency . "IRT"]) && is_numeric($data['data'][$currency . "IRT"])) {
        return floatval($data['data'][$currency . "IRT"]);
    }

    return null;
}


//function convertCurrencyToToman($message)
//{
//    if (preg_match('/تبدیل\s+(\d+(\.\d+)?)\s+([آ-یA-Za-z]+)/u', $message, $matches)) {
//        $amount = (float) $matches[1];
//        $currency = translateCurrency(trim($matches[3]));
//        $price = getCurrencyPrice($currency);
//        if ($price) {
//            $totalPrice = $amount * $price / 10;
//            $txt = "`💰 $amount $currency: " . number_format($totalPrice) . " Toman`";
//            return send($txt);
//        } else {
//            return null;
//            //$txt = "❌ ارز \"$currency\" پشتیبانی نمی‌شود یا قیمت آن قابل دریافت نیست.";
//            //return send($txt);
//        }
//    }
//    //$txt = "❌ لطفاً پیام خود را به صورت صحیح ارسال کنید. مثال: `تبدیل 10 TRX` یا `تبدیل 5 BTC`";
//    //return send($txt);
//}

function hasRestrictedContent($message) {
    
    $hasCustomEmoji = false;

    if (isset($message->entities)) {
        foreach ($message->entities as $entity) {
            if ($entity->type === 'custom_emoji') {
                $hasCustomEmoji = true;
                break;
            }
        }
    }
    
    return isset($message->animation) ||  // گیف
           isset($message->sticker) ||    // استیکر
           isset($message->photo) ||      // عکس
           isset($message->video) ||      // فیلم
           isset($message->voice) ||      // ویس
           isset($message->audio) ||      // موزیک
           isset($message->location) ||   // لوکیشن
           isset($message->game) ||       // بازی
           isset($message->document) ||   // فایل
           isset($message->poll) ||       // نظرسنجی
           $hasCustomEmoji;               // ایموجی پرمیوم
}


function convertCurrencyToToman($message)
{
    if (preg_match('/تبدیل\s+([0-9۰-۹]+(\.[0-9۰-۹]+)?)\s+([آ-یA-Za-z]+)/u', $message, $matches)) {
    
        // تبدیل اعداد فارسی به انگلیسی
        $amount = (float) str_replace(['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'], ['0','1','2','3','4','5','6','7','8','9'], $matches[1]);
        $currency = translateCurrency(trim($matches[3]));

        $price = getCurrencyPrice($currency);
        if ($price) {
            $totalPrice = $amount * $price;
            $txt = "`💰 $amount $currency: " . number_format($totalPrice) . " Toman`";
            return send($txt);
        } else {
            return null;
            //$txt = "❌ ارز \"$currency\" پشتیبانی نمی‌شود یا قیمت آن قابل دریافت نیست.";
            //return send($txt);
        }
    }
    //$txt = "❌ لطفاً پیام خود را به صورت صحیح ارسال کنید. مثال: `تبدیل 10 TRX` یا `تبدیل 5 BTC`";
    //return send($txt);
}

/**
 * @param string $step
 * @return void
 */
function Savestep(string $step): void
{
    global $uid;
    file_put_contents('database/' . $uid . '.txt', $step);
}

/**
 * @return false|string
 */
function Getstep(): false | string
{
    global $uid;
    /** @var string $step */
    @$step = file_get_contents('database/' . $uid . '.txt');
    return $step;
}

/**
 * @return false|string
 */
function Getgp(): false | string
{
    global $chid;
    /** @var string $step */
    $gp = file_get_contents('database/' . 'gp.txt');
    return $gp;
}

/**
 * @return int[]
 */
function Getadmins(): array
{
    $admins = file_get_contents('database/' . 'admins.txt');
    /** @var array $admins */
    $admins = explode("\n", $admins);
    return $admins;
}

$update = json_decode(file_get_contents("php://input"));
if (!$update) {exit;}
if (!is_dir('database')) {mkdir('database');}
$home = json_encode([
    'keyboard' => [
        [['text' => 'تنظیم ادمین'], ['text' => 'تنظیم گروه']],
        [['text' => '🔙 بازگشت']],
    ],
    'resize_keyboard' => true,
]);
$back = json_encode([
    'keyboard' => [
        [['text' => '🔙 بازگشت']],
    ],
    'resize_keyboard' => true,
]);

if (isset($update->message)) {
    $message = $update->message;
    $mid = $message->message_id;
    $chid = $message->chat->id;
    @$msg = $message->text;
    $uid = $message->from->id;

    if (isset($update->new_chat_member)) {
        Savestep('none');
    }

    if (in_array($uid, Getadmins())) {
        if ($msg == '/start' || $msg == '🔙 بازگشت') {
            Savestep('none');
            send('سلام به پنل مدیریت خوش آمدید.', keyboard: $home);
        }
        elseif ($msg == 'تنظیم گروه') {
            Savestep('setGp');
            send('لطفا آیدی عددی گروه همراه -100 ارسال کنید : ', keyboard: $back);
        }
        elseif ($msg == 'تنظیم ادمین') {
            Savestep('setAdmins');
            send('طفا آیدی عددی ادئمین ها را به صورت خطی ارسال کنید :', keyboard: $back);
        }
        elseif (Getstep() == 'setGp') {
            Savestep('none');
            file_put_contents('database/' . 'gp.txt', $msg);
            send('گروه ' . $msg . ' با موفقیت تنظیم شد!', keyboard: $home);
        }
        elseif (Getstep() == 'setAdmins') {
            Savestep('none');
            file_put_contents('database/' . 'admins.txt', $msg);
            send('ادمین ها  با موفقیت تنظیم شدند.', keyboard: $home);
        }
    }
    if ($chid == Getgp()) {
        if (hasRestrictedContent($message)) {
            if (!in_array($uid, Getadmins())) {
                deleteMessage($chid, $mid);
                exit;
            }
        }

        $linkPattern = "/https?:\/\/(?![^\/]*tronscan)[\w.-]+(?:\.[\w.-]+)+[\w\-._~:\/?#[\]@!$&'()*+,;=]*/";
        if (preg_match($linkPattern, $msg)) {
            if (!in_array($uid, Getadmins())) {
                deleteMessage($chid, $mid);
                exit;
            }
        }
        $hashPattern = '/^[^\/\\\\][a-fA-F0-9]{63}$/';
        $tronScanPattern = '/^https:\/\/tronscan\.org\/#\/transaction\/[a-fA-F0-9]{64}$/';
        if (preg_match($hashPattern, $msg)) {
            $transactionInfo = getTransactionFromTronScan($msg);
            $sp_mode = true;
        }
        elseif (preg_match($tronScanPattern, $msg)) {
            $sp_mode = false;
            deleteMessage($chid, $mid);
            $hash = substr($msg, strrpos($msg, '/') + 1);
            $transactionInfo = getTransactionFromTronScan($hash);
        }
        if (isset($transactionInfo['hash'])) {
            $hash = $transactionInfo['hash'];
            $from = $transactionInfo['ownerAddress'] ?? 'نامشخص';
            $to = $transactionInfo['toAddress'] ?? 'نامشخص';
            $amount = $transactionInfo['contractData']['amount'] ?? 0;
            $amountTrx = $amount / 1_000_000;
            $timestamp = $transactionInfo['timestamp'] ?? time();
            $status = $transactionInfo['contractRet'] ?? 'نامشخص';
            $statusText = $status === 'SUCCESS' ? 'SUCCESS ✔️' : 'FAILED ❌';
            $date = date('Y-m-d', $timestamp / 1000);
            $time = date('H:i:s', $timestamp / 1000);
            $responseMessage = "🔍 وضعیت تراکنش:  `$statusText` \n\n";
            $responseMessage .= "#️⃣ هش تراکنش:  `$hash` \n\n";
            $responseMessage .= "📅 تاریخ تراکنش:  `$date` \n\n";
            $responseMessage .= "🕒 ساعت تراکنش:  `$time` \n\n";
            $responseMessage .= "🪙 مقدار ترون تراکنش:  `$amountTrx` \n\n";
            $responseMessage .= "🔜 ولت مبدا:  `$from` \n\n";
            $responseMessage .= "🔚 ولت مقصد:  `$to` ";
            send($responseMessage, $chid, sp_mode: $sp_mode);
            exit;
        }
        
        if (isset($msg[0]) && $msg[0] === '+') {
            if (!in_array($uid, Getadmins())) {
                deleteMessage($chid, $mid);
            }
        } 
        if (preg_match('/[0-9]{6,}|[۰-۹]{6,}/u', $msg)) {
            if (
                !preg_match('/^[a-fA-F0-9]{64}$/', $msg) &&
                !preg_match('/^https:\/\/tronscan\.org\/#\/transaction\/[a-fA-F0-9]{64}$/', $msg)
            ) {
                deleteMessage($chid, $mid);
            }
        }
        if ($msg == 'واسطه' || $msg == 'واسط' || $msg == 'vasete' || $msg == 'vaset') {
            $groupAdmins = getGroupAdmins($chid);
            if (!empty($groupAdmins)) {
                $batchSize = 5;  // تعداد ادمین‌هایی که در هر پیام تگ می‌شوند
                $adminCount = count($groupAdmins);

                // تابع برای escape کردن کاراکترهای حساس Markdown
                function escapeMarkdown($text) {
                    $replacements = [
                        '[' => '\\[',
                        ']' => '\\]',
                        '(' => '\\(',
                        ')' => '\\)'
                    ];
                    return strtr($text, $replacements);
                }

                // تقسیم ادمین‌ها به دسته‌های 5تایی
                for ($i = 0; $i < $adminCount; $i += $batchSize) {
                    $batch = array_slice($groupAdmins, $i, $batchSize);  // برش دادن ادمین‌ها به اندازه 5
                    $batchMentions = '';

                    foreach ($batch as $admin) {
                        // Escape کردن نام ادمین
                        $escapedName = escapeMarkdown($admin['name']);
                        $batchMentions .= "[{$escapedName}](tg://user?id={$admin['id']}) ✗";
                    }

                    // ارسال هر دسته از ادمین‌ها
                    send($batchMentions, chatid: $chid);
                }
                exit;
            } else {
                send('هیچ ادمینی یافت نشد یا خطایی رخ داده است.');
                exit;
            }
        }
        convertCurrencyToToman($msg);
        exit;
    }
}
elseif (isset($update->callback_query)) {
    $data = $update->callback_query->data;
    $cid = $update->callback_query->id;
    $chat_id = $update->callback_query->message->chat->id;
    $from_id = $update->callback_query->from->id;
    $message_id = $update->callback_query->message->message_id;
}
elseif (isset($update->inline_query)) {
    $query_id = $update->inline_query->id;
    $offset = $update->inline_query->offset == '' ? 0 : $update->inline_query->offset;
    $from_id = $update->inline_query->from->id;
}
